in vec2 uv;
in vec2 uvn;

out vec2 C;


uniform int input_tex;
uniform int output_tex;
uniform bool wide;

const float vertical_weights[25] = float[25](
    -5., -8., -10., -8., -5.,
    -4.,-10.,-20.,-10.,-4.,
    0.,0.,0.,0.,0.,
    4.,10.,20.,10.,4.,
    5.,8.,10.,8.,5.
);

// horizontal gradient
const float horizontal_weights[25] = float[25](
    -5., -4., 0., 4., 5.,
    -8., -10.,0.,10.,8.,
    -10.,-20.,0.,20.,10.,
    -8.,-10.,0.,10.,8.,
    -5.,-4.,0.,4.,5.
);

mat3 sobel=mat3(
    -1, 0, 1,
    -2, 0, 2,
    -1, 0, 1
);

void main() {
    vec2 image_res = vec2(textureSize(textures[output_tex], 0).xy);
    
    vec2 u = gl_FragCoord.xy/vec2(image_res);
//    C = texture(textures[input_tex], u);


    float horiz_sum = 0.;
    float vert_sum = 0.;

    if(wide){
        for (int i = 0; i < 5; i++) {
            for (int j = 0; j < 5; j++) {
                vec2 uv = u+(vec2(j,i)-2)*1./image_res;
                vec4 c = texture(textures[input_tex], uv);
//                c = pow(c,vec4(0.45454545));
                c = sqrt(c);
                horiz_sum += horizontal_weights[i*5+j]*luma(c.rgb);
                vert_sum +=   vertical_weights[i*5+j]*luma(c.rgb);
            }
        }
        C.x = horiz_sum/240.;
        C.y = vert_sum/240.;

        C.xy *= 1;
    } else {
        vec2 W = vec2(0);
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                vec2 uv = u+(vec2(j,i) - 1.0)*1./image_res;
                vec4 c = texture(textures[input_tex], uv);
                
                c = pow(c,vec4(1./0.45454545));
                
                float hw = sobel[i][j];
                float vw = sobel[j][i];
                W.x += hw;
                W.y += vw;
                horiz_sum += hw*luma(c.rgb);
                vert_sum += vw*luma(c.rgb);
            }
        }

        C.x = horiz_sum;
        C.y = vert_sum;
        C.xy *= 0.125;
    }
//    C = abs(C);
}

